
=begin

もんむす・くえすと！ＲＰＧ
　トリス加入演出確認 ver1  2016/04/19

設定の USE を true にすると、以下の効果が発生する

①　仲間化確率を無視して、必ず起き上がる
　戦闘勝利時、
　敵グループに「仲間化可能な敵」がいれば、確実に起き上がる

②　加入済みの敵も起き上がる
　戦闘勝利時の仲間加入で、
　すでに加入済み（パーティ/城）の敵であっても、「仲間化可能な敵」と扱う

　※加入させた後のプレイは保証しない
　　あくまで加入演出のテスト用

③　出てくる敵を、変数で指定できる
　戦闘開始時、
　特定変数の値が1以上なら、全ての敵のエネミーIDが「その変数の値」になる
　（全ての敵が、変数で指定した敵にすり替わる）



=end

module FollowerTest
  
  # true:有効　false:無効
  USE = false
  
  # 「すり替え先エネミーIDを指定する変数」のID
  # 「この設定が1以上」かつ「その変数の値が1以上」ならば、すり替えが行われる
  VAR_ID = 5000
  
end

if FollowerTest::USE
print "\n"
print "※スクリプト「トリス加入演出確認」が有効です\n"
print "  確認が終わったら無効にしてください\n"
print "\n"
#==============================================================================
# ■ Game_Troop
#==============================================================================
class Game_Troop < Game_Unit
  #--------------------------------------------------------------------------
  # ● 仲間化の抽選
  #--------------------------------------------------------------------------
  def check_getup
    e = @dead_enemies.reverse.uniq.select{|enemy|
      enemy.follower?
    }.sample
    # テスト用途中経過表示
    if $TEST
      print "ID#{e.id} #{e.name}\n"
      print "必ず加入(スクリプト「トリス加入演出確認」)\n"
    end
    @follower_enemy = e
  end  
end
#==============================================================================
# ■ RPG::Troop::Member
#==============================================================================
class RPG::Troop::Member
  #--------------------------------------------------------------------------
  # ● エネミーID
  #--------------------------------------------------------------------------
  def enemy_id
    var_id = FollowerTest::VAR_ID
    if var_id != 0
      var_value = $game_variables[var_id]
      return var_value if var_value > 0
    end
    return @enemy_id
  end
end

end
